/**
 * This script will split a stereo track into two separate tracks.
 * 
 * Written By: Edward Troxel
 * Copyright 2005 - JETDV Scripts
 * Modified: 10-17-2005
 **/

import System;
import System.IO;
import System.Windows.Forms;
import Sony.Vegas;




try {
  for(var track : Track in Vegas.Project.Tracks) 
  {
    if (track.IsAudio() && track.Selected)
    {
      //Add a new audio track
      var Rtrack = new AudioTrack(track.Index, "Audio-Right");
      Vegas.Project.Tracks.Add(Rtrack);

      for(var evnt : TrackEvent in track.Events) 
      {
        //Copy all events to the Ltrack
        var mynewEvent = evnt.Copy(Rtrack, evnt.Start);
        //Set right to disable left
        var audioEvent : AudioEvent = AudioEvent(mynewEvent);
        audioEvent.Channels = ChannelRemapping.DisableLeft;
        //Set left to disable right
        audioEvent = AudioEvent(evnt);
        audioEvent.Channels = ChannelRemapping.DisableRight;
      }
      break;
    }
  }

} catch (e) {
    MessageBox.Show(e);
}